/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.badlogic.gdx.graphics.Color;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PoisonLoseHpAction
extends AbstractGameAction {
    private static final Logger logger = LogManager.getLogger(PoisonLoseHpAction.class.getName());
    private static final float DURATION = 0.33f;

    public PoisonLoseHpAction(AbstractCreature target, AbstractCreature source, int amount, AbstractGameAction.AttackEffect effect) {
        this.setValues(target, source, amount);
        this.actionType = AbstractGameAction.ActionType.DAMAGE;
        this.attackEffect = effect;
        this.duration = 0.33f;
    }

    @Override
    public void update() {
        if (AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
            this.isDone = true;
            return;
        }
        if (this.duration == 0.33f && this.target.currentHealth > 0) {
            logger.info(this.target.name + " HAS " + this.target.currentHealth + " HP.");
            this.target.damageFlash = true;
            this.target.damageFlashFrames = 4;
            AbstractDungeon.effectList.add(new FlashAtkImgEffect(this.target.hb.cX, this.target.hb.cY, this.attackEffect));
        }
        this.tickDuration();
        if (this.isDone) {
            AbstractPower p;
            if (AbstractDungeon.player.hasRelic("The Specimen") && !this.target.isPlayer && this.target.currentHealth <= this.amount) {
                int potency = this.target.getPower((String)"Poison").amount;
                if (potency == 1 && !AbstractDungeon.player.hasPower("Venomology")) {
                    this.target.powers.remove(this.target.getPower("Poison"));
                } else if (AbstractDungeon.getRandomMonster((AbstractMonster)this.target) != null && !AbstractDungeon.player.hasPower("Venomology")) {
                    --this.target.getPower((String)"Poison").amount;
                } else if (AbstractDungeon.getRandomMonster((AbstractMonster)this.target) != null && AbstractDungeon.player.hasPower("Venomology")) {
                    this.target.getPower((String)"Poison").amount += AbstractDungeon.player.getPower((String)"Venomology").amount;
                }
            }
            if (this.target.currentHealth > 0) {
                this.target.tint.color = Color.CHARTREUSE.cpy();
                this.target.tint.changeColor(Color.WHITE.cpy());
                this.target.damage(new DamageInfo(this.source, this.amount, DamageInfo.DamageType.HP_LOSS));
                if (this.target.isDying && ++AbstractPlayer.poisonKillCount == 3 && AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT) {
                    UnlockTracker.unlockAchievement("PLAGUE");
                }
            }
            if (!AbstractDungeon.player.hasPower("Venomology") || this.target.isPlayer) {
                AbstractPower p2 = this.target.getPower("Poison");
                if (p2 != null) {
                    --p2.amount;
                    if (p2.amount == 0) {
                        this.target.powers.remove(p2);
                    } else {
                        p2.updateDescription();
                    }
                }
            } else if (AbstractDungeon.player.hasPower("Venomology") && !this.target.isPlayer && (p = this.target.getPower("Poison")) != null) {
                p.amount += AbstractDungeon.player.getPower((String)"Venomology").amount;
            }
            if (AbstractDungeon.getCurrRoom().monsters.areMonstersBasicallyDead()) {
                AbstractDungeon.actionManager.clearPostCombatActions();
            }
            AbstractDungeon.actionManager.addToTop(new WaitAction(0.1f));
        }
    }
}

